package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;
import gov.va.med.mhv.usermgmt.data.model.DirectMessage;
import gov.va.med.mhv.usermgmt.data.repository.DirectMessageRepository;
import gov.va.med.mhv.usermgmt.main.service.converter.DirectMessageConverter;
import gov.va.med.mhv.usermgmt.main.service.converter.DirectMessageDTOConverter;
import gov.va.med.mhv.usermgmt.service.DirectMessageService;

/**
 * Service implementation class for the DirectMessage service
 * 
 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService
 */
@Component
public class DirectMessageServiceImpl implements DirectMessageService {

	private static final DirectMessageDTOConverter DM_DTO_CONVERTER = new DirectMessageDTOConverter();

	private static final DirectMessageConverter DM_CONVERTER = new DirectMessageConverter();

	@Autowired
	private DirectMessageRepository repository;
	
	@Override
	public Long saveDirectMessage(DirectMessageDTO directMessage) {

		DirectMessage dm = DM_CONVERTER.convert(directMessage);
		dm = this.repository.save(dm);
		return dm.getDirectMessageId();

	}

	@Override
	public List<DirectMessageDTO> getDirectMessagesByDirectMessageStatusAndUserProfileId(
			Long userProfileId, String directMessageStatus) {

		List<DirectMessageDTO> response = new ArrayList<>();

		List<DirectMessage> messages = this.repository
				.getByUserProfileIdAndDirectMessageStatus(userProfileId,
						directMessageStatus);

		if (messages != null && messages.size() > 0) {
			for (DirectMessage dm : messages) {
				response.add(DM_DTO_CONVERTER.convert(dm));
			}
		}

		return response;
	}

	@Override
	public List<DirectMessageDTO> getDirectMessagesByUserProfileId(
			Long userProfileId) {
		List<DirectMessageDTO> response = new ArrayList<>();

		List<DirectMessage> messages = this.repository
				.getByUserProfileId(userProfileId);

		if (messages != null && messages.size() > 0) {
			for (DirectMessage dm : messages) {
				response.add(DM_DTO_CONVERTER.convert(dm));
			}
		}

		return response;
	}
	
	@Override
	public List<DirectMessageDTO> getDirectMessagesSentTodayByUserProfileId(
			Long userProfileId) {
		List<DirectMessageDTO> response = new ArrayList<>();

		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		java.util.Date today = calendar.getTime();
		java.sql.Timestamp todayTimestamp = new java.sql.Timestamp(today.getTime());
		
		List<DirectMessage> messages = this.repository
				.getByUserProfileIdAndCreatedDate(userProfileId, todayTimestamp);

		if (messages != null && messages.size() > 0) {
			for (DirectMessage dm : messages) {
				if(dm.getCreatedDate().getTime() > todayTimestamp.getTime())
					response.add(DM_DTO_CONVERTER.convert(dm));
			}
		}
		
		return response;
	}

	@Override
	public List<DirectMessageDTO> getDirectMessagesByDirectMessageStatus(String directMessageStatus) {

		List<DirectMessageDTO> response = new ArrayList<>();

		List<DirectMessage> messages = this.repository.getByDirectMessageStatus(directMessageStatus);

		if (messages != null && messages.size() > 0) {
			for (DirectMessage dm : messages) {
				response.add(DM_DTO_CONVERTER.convert(dm));
			}
		}

		return response;
	}
}